#include <iostream>
#include <vector>
#include <unordered_set>

struct Bank {
    int coins;
    std::unordered_set<Bank*> neighbours;
};

template<typename T>
void Merge2Left(std::unordered_set<T>& left, const std::unordered_set<T>& right, const std::unordered_set<T>& exclusionSet) {
    for (auto& val : right) {
        if (left.find(val) != left.end() || exclusionSet.find(val) != exclusionSet.end()) {
            continue;
        }
        left.insert(val);
    }
}
int Cost(Bank* from) {
    int depth = 0;
    int cost = 0;
    std::unordered_set<Bank*> traversed;
    std::unordered_set<Bank*> queued = { from };
    while (queued.size()) {
        std::unordered_set<Bank*> newQueue;
        for (auto& node : queued) {
            if (traversed.find(node) != traversed.end()) {
                continue;
            }
            cost += depth * node->coins;
            Merge2Left(newQueue, node->neighbours, traversed);
            traversed.insert(node);
        }
        ++depth;
        queued = newQueue;
    }
    return cost;
}
void OptimiseIO() {
    std::ios_base::sync_with_stdio(false);
    std::cout.tie(0);
    std::cerr.tie(0);
    std::cin.tie(0);
}

void CaseA(std::vector<Bank*>& banks) {
    int minCost = INT32_MAX;
    int bankId = -1;
    for (int i = 0; i < banks.size(); ++i) {
        int cost = Cost(banks[i]);
        if (cost < minCost) {
            bankId = i;
            minCost = cost;
        }
    }
    std::cout << bankId + 1 << std::endl;
}

int main() {
    OptimiseIO();
    int n;
    int q;
    std::cin >> n;
    std::vector<Bank*> banks(n);
    for (auto& bank : banks) {
        bank = new Bank();
    }
    int N = n;
    while (--N) {
        int a;
        int b;
        std::cin >> a >> b;
        --a;
        --b;
        banks[a]->neighbours.insert(banks[b]);
        banks[b]->neighbours.insert(banks[a]);
    }
    N = n;
    while (N--) {
        std::cin >> banks[n - N - 1]->coins;
    }
    CaseA(banks);
    return 0;
}